﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancel
{
    /// <summary>
    /// Deserialize Appointment step.
    /// </summary>
    public class SerializeAppointmentStep : FilterBase<MakeCancelStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelStateObject state)
        {
            try
            {
                state.SerializedRequestMessage = PipelineUtilities.SerializeInstance(state.RequestMessage);
                Logger.Instance.Info(string.Format("INFO: HealthShare Make and Cancel Appointment Data: {0}", state.SerializedRequestMessage));
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Make Cancel SerializeAppointmentStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}